/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.vfx.campfire;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.RestRoom;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;

public class UNUSEDCampfireMeditateEffect
extends AbstractGameEffect {
    private static final float DUR = 5.0f;
    private boolean openedPurgeScreen = false;
    private boolean purgedCard = false;
    private Color screenColor = Color.BLACK.cpy();

    public UNUSEDCampfireMeditateEffect() {
        this.duration = 5.0f;
        this.screenColor.a = 0.0f;
        AbstractDungeon.overlayMenu.proceedButton.hide();
    }

    @Override
    public void update() {
        if (!AbstractDungeon.isScreenUp) {
            this.duration -= Gdx.graphics.getDeltaTime();
            this.updateBlackScreenColor();
        }
        if (!this.purgedCard && !AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            for (AbstractCard c : AbstractDungeon.gridSelectScreen.selectedCards) {
                AbstractDungeon.player.masterDeck.removeCard(c);
                AbstractDungeon.effectsQueue.add(new PurgeCardEffect(c));
            }
            AbstractDungeon.gridSelectScreen.selectedCards.clear();
            this.purgedCard = true;
            ++CardCrawlGame.metricData.campfire_meditates;
            ((RestRoom)AbstractDungeon.getCurrRoom()).fadeIn();
        }
        if (this.duration < 2.5f && !this.openedPurgeScreen) {
            this.openedPurgeScreen = true;
            AbstractDungeon.gridSelectScreen.open(AbstractDungeon.player.masterDeck, 1, "Select a card to remove from your deck.", false);
            for (AbstractRelic r : AbstractDungeon.player.relics) {
                r.onMeditate();
            }
        }
        if (this.duration < 0.0f) {
            this.isDone = true;
            AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
        }
    }

    private void updateBlackScreenColor() {
        this.screenColor.a = this.duration > 3.5f ? Interpolation.fade.apply(0.0f, 1.0f, (5.0f - this.duration) / 1.5f) : (this.duration < 1.0f ? Interpolation.fade.apply(1.0f, 0.0f, 1.0f - this.duration) : 1.0f);
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(this.screenColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.GRID) {
            AbstractDungeon.gridSelectScreen.render(sb);
        }
    }
}

